/*****************************************************************************
*  LPC13Axx SCT demo
*
*  Use SCT0 L counter part to toggle SCT0_OUT0 every 100 usec
*  SCT PLL is running at 156 MHz
*  LPC13A4x - SCT0/1 support:  8 inputs
*                              10 outputs
*                              16 match/capture registers
*                              16 events
*                              16 states
*             SCT2/3 support:  3 inputs
*                              6 outputs
*                              8 match/capture registers
*                              10 events
*                              10 states
*****************************************************************************/
#include "LPC15xx.h"

void SCT0_Init(void)
{
    LPC_SYSCON->SYSAHBCLKCTRL1 |= EN1_SCT0;                // enable the SCT0 clock

    LPC_SCT0->CONFIG           |= (1 << 17);               // two 16 bit timers, auto limit
    LPC_SCT0->CTRL_L           |= (119 << 5);              // PRE_L[12:5] = 120-1 (SCT clock = 12MHz/120 = 100 KHz)

    LPC_SCT0->MATCH[0].L        = (100000/10)-1;           // match 0 @ 10 Hz = 100 msec
    LPC_SCT0->MATCHREL[0].L     = (100000/10)-1;

    LPC_SCT0->EVENT[0].STATE    = 0xFFFF;                  // event 0 happens in all state
    LPC_SCT0->EVENT[0].CTRL     = (1 << 12);               // match 0 condition only

    LPC_SCT0->OUT[0].SET        = (1 << 0);                // event 0 will set   SCT0_OUT0
    LPC_SCT0->OUT[0].CLR        = (1 << 0);                // event 0 will clear SCT0_OUT0
    LPC_SCT0->RES               = (3 << 0);                // output 0 toggles on conflict

    LPC_SCT0->CTRL_L           &= ~(1 << 2);               // start timer
}
